@foreach($purchase_requisition->purchase_lines as $purchase_line)
	@if($purchase_line->quantity - $purchase_line->po_quantity_purchased > 0)
        @php
            // Ensure PR unit cost is available to PO rows
            $pr_cost = $purchase_line->pp_without_discount
                ?: $purchase_line->purchase_price
                ?: $purchase_line->purchase_price_inc_tax
                ?: optional($purchase_line->variations)->default_purchase_price
                ?: 0;
            $purchase_line->pp_without_discount = $pr_cost;
            $purchase_line->purchase_price = $pr_cost;
            $purchase_line->purchase_price_inc_tax = $pr_cost;
        @endphp
        @php
            // Push cost into variation defaults so PO row calculators see it
            if (isset($purchase_line->variations)) {
                $purchase_line->variations->default_purchase_price = $pr_cost;
                $purchase_line->variations->dpp_inc_tax = $pr_cost;
            }
        @endphp
		@include('purchase.partials.purchase_entry_row', [
			'variations' => [$purchase_line->variations],
			'product' => $purchase_line->product,
			'row_count' => $row_count,
			'variation_id' => $purchase_line->variation_id,
			'taxes' => $taxes,
			'currency_details' => $currency_details,
			'hide_tax' => $hide_tax,
			'sub_units' => $sub_units_array[$purchase_line->id],
			'purchase_requisition_line' => $purchase_line,
            'pr_unit_cost' => $pr_cost,
			'purchase_requisition' => $purchase_requisition
		])
		@php
			$row_count++;
		@endphp
	@endif
@endforeach
